// ctmpwidthDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ctmpwidth.h"
#include "ctmpwidthDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCtmpwidthDlg dialog

CCtmpwidthDlg::CCtmpwidthDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCtmpwidthDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCtmpwidthDlg)
	m_counts = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCtmpwidthDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCtmpwidthDlg)
	DDX_Text(pDX, IDC_EDIT1, m_counts);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCtmpwidthDlg, CDialog)
	//{{AFX_MSG_MAP(CCtmpwidthDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_START, OnStart)
	ON_BN_CLICKED(IDC_READ, OnRead)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCtmpwidthDlg message handlers

BOOL CCtmpwidthDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	LogicalDevice=0; //this is the DriverLINX logical device number
	m_pSR=(DL_ServiceRequest*) new DL_ServiceRequest;  
	m_DriverInstance=OpenDriverLINX(m_hWnd,"kmbctm");
	memset(m_pSR,0,sizeof(DL_ServiceRequest));
	DL_SetServiceRequestSize(*m_pSR);
	m_pSR->operation=INITIALIZE;
	m_pSR->device=LogicalDevice;
	m_pSR->subsystem=DEVICE;
	m_pSR->hWnd=m_hWnd;
	m_pSR->mode=OTHER;
	DriverLINX(m_pSR);  //Execute the service request to initialize the board
	showMessage(m_pSR); //show errors, if any
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCtmpwidthDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCtmpwidthDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCtmpwidthDlg::OnButton1() 
{
	// TODO: Add your control notification handler code here
	delete m_pSR;
	m_pSR=NULL;
	CloseDriverLINX(m_DriverInstance);
	m_DriverInstance=NULL;
	OnOK();
	
}

void CCtmpwidthDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
	return;
}

void CCtmpwidthDlg::OnStart() 
{
	// TODO: Add your control notification handler code here
	memset(m_pSR,0,sizeof(DL_ServiceRequest));
	DL_SetServiceRequestSize(*m_pSR);
	m_pSR->operation=START;
	m_pSR->device=LogicalDevice;
	m_pSR->subsystem=CT;
	m_pSR->mode=POLLED;
	m_pSR->timing.typeEvent=RATEEVENT;
	m_pSR->timing.u.rateEvent.channel=0; //Uses CT channel 0
	m_pSR->timing.u.rateEvent.mode=PULSEWD;
	m_pSR->timing.u.rateEvent.clock=INTERNAL1; //This will use internal1 for the clock source.  Use something slower if the pulses are longer.
	m_pSR->timing.u.rateEvent.gate=HILEVELGATEN; //Use active high gating for pulse width.  Change to edge gating for period measurement
	m_pSR->timing.u.rateEvent.period=0;
	m_pSR->timing.u.rateEvent.onCount=0;
	m_pSR->timing.u.rateEvent.pulses=0;  
	m_pSR->hWnd=m_hWnd;
	DriverLINX(m_pSR);
	showMessage(m_pSR);

	GetDlgItem(IDC_READ)->EnableWindow(TRUE);

			/*
    This application was tested with a CTM-05/A in Win98SE using
	CTM-850A01.0.0.2 version of DriverLINX

    In the DriverLINX Configuration Panel, the timebase resolution is set
	for 1.0 MHz and the Freq Scaler is BCD (Binary tested too).

    When using Internal1, the timebase will be either 1MHz or 5MHz depending on
	the selection in the DriverLINX Configuration Panel

    At 1MHz, the pulse can be no longer than 65.5 msec in duration.  After which the
	16bit counter will roll over and the count value will be corrupt.  (At 5MHz, the pulse
	can be only 13 msec before roll over occurs)

    For pulses longer than 65 msec, select one of the slower timebase:  INTERNAL2...INTERNAL5

    Depending on the selection of BCD or Binary freq scaler in DLinx Config Panel, these
	slower timebase will be decades of 10 or decades of 16 slower, e.g.:

                  
	BCD and 1MHz:  1MHz, 100KHz, 10KHz, 1KHz, 100Hz
	Binary and 1MHz:  1MHz, 62.5KHz, 3906 Hz, 244 Hz, 15 Hz
    
	

  */
	
}

void CCtmpwidthDlg::OnRead() 
{
	// TODO: Add your control notification handler code here
	int counts;
	int result;
	float period;
	m_pSR->operation=STATUS; //The key here is NOT to reset the service request elements with memset, since we are getting a status on the existing service request
	m_pSR->status.typeStatus=TIMERSTATUS;  //Get the status of the counter timer
	DriverLINX(m_pSR);  //Execute the status service request
	showMessage(m_pSR); //Show errors, if any
	counts=m_pSR->status.u.timerStatus.count; //Get the raw counts
	result=Tics2Sec(LogicalDevice,CT,INTERNAL1,counts,&period); //Convert counts to seconds
	m_counts.Format("%f",period);
    UpdateData(FALSE);

	/*
      The Tics2Sec function seems to work correctly only for the INTERNAL1 timebase.

      If using one of the slower timebases to accomodate longer pulses, then do not use
	  the Tics2Sec function, but instead muliply the number of counts by the selected timebase
	  resolution.
  */

  /*
     The driver will report zero counts until the second rising edge is detected.  Below is
	 a diagram of the GATE signal.  When the signal is logic 1, counts from the selected 
	 internal timebase accumulate, but the counter will report zero until the gate goes high
	 again (at which time it also resets and resumes accumulation of counts).

            _________________             ______________
           |                |            |             |
     ______|                |____________|             |_______

           |<--- counts --->|            | <-- reading reported
  */


}
